/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ConfigurableCombBlockRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public ConfigurableCombBlockRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() == 1 && stacks.get(0).m_41720_().equals(ModItems.CONFIGURABLE_COMB_BLOCK.get())) {
            return stacks.get(0).m_41782_();
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
            outStack.m_41751_(inStack.m_41783_());
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    private List<ItemStack> getItemsInInventory(CraftingContainer inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get()}));
        return nonnulllist;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.CONFIGURABLE_COMB_BLOCK.get();
    }

    public static class Serializer<T extends ConfigurableCombBlockRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id, 4);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config comb block recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((ConfigurableCombBlockRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config comb block recipe to packet. " + ((ConfigurableCombBlockRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ConfigurableCombBlockRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

